% ALPHA ENGINE DEFINITION
% Generated 18-Aug-2023 07:51:40

% SUGGESTED CITATION:
% 2018 Mazda 2.5L Skyactiv-G Engine Tier 3 Fuel - ALPHA Map Package. Version 2023-08. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2023.


% Constructor
engine = class_REVS_engine();
engine.name =  '2018 Mazda 2.5L Skyactiv-G Engine Tier 3 Fuel'; 
engine.source_filename = mfilename;
engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  2.488; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  13; 
engine.stroke_mm =  100; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	     0.0000000000000000	;     104.40559585430078	;     156.76547341413067	;     209.02063121884089	;     339.81560536329596	;     418.87902047863906	;     628.31853071795865	;     659.73445725385659	;     691.15038378975453		]; 
engine.full_throttle_torque_Nm = [	     0.0000000000000000	;     166.40000000000001	;     201.00000000000000	;     219.09999999999999	;     237.19999999999999	;     252.18214799999998	;     221.93501302700693	;     190.23001116600594	;     0.0000000000000000		]; 
engine.naturally_aspirated_speed_radps = [	     0.0000000000000000	;     133.54955900738526	;     235.20056999875584	;     261.37201798771514	;     287.45572780346617	;     313.63412658698218	;     365.88854787167566	;     418.25070194792107	;     470.55447963893687	;     691.15038378975453		]; 
engine.naturally_aspirated_torque_Nm = [	     101.16679563487645	;     152.75147594211896	;     199.65532860476341	;     204.81943397831103	;     205.98007540514214	;     213.63290215662423	;     242.91535897439786	;     265.59776331078376	;     309.23320656669739	;     530.57983062165079		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	     0.0000000000000000	;     114.98229112138642	;     235.20056999875584	;     313.63566658338101	;     522.86573731246119	;     691.15038378975453		]; 
engine.closed_throttle_torque_Nm = [	    -20.041822849807446	;    -26.300000000000001	;    -30.699999999999999	;    -32.299999999999997	;    -48.500000000000000	;    -57.659281129653401		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	     0.0000000000000000	;     52.249921816954256	;     104.49984363390851	;     114.96265616730150	;     133.54955900738526	;     156.76855340692828	;     182.94541219404559	;     209.02204635066693	;     235.20056999875584	;     261.37201798771514	;     287.45572780346617	;     313.63412658698218	;     339.80449872260135	;     365.88854787167566	;     418.25070194792107	;     470.55447963893687	;     522.85825732995261	;     607.00432055985357	;     691.15038378975453		]; 
engine.fuel_map_torque_Nm = [	    -60.542245186136071	;    -48.149999999999999	;    -30.586764705882352	;    -14.100000000000000	;    -1.9485915492957753	;     12.901666666666667	;     23.372222222222220	;     29.085714285714285	;     36.721052631578949	;     43.310000000000002	;     50.715909090909093	;     63.681481481481484	;     74.104999999999990	;     82.481249999999989	;     94.012499999999989	;     100.09999999999999	;     112.67500000000001	;     122.20624999999998	;     131.73749999999995	;     142.54999999999998	;     158.92000000000002	;     168.41217391304349	;     177.90434782608696	;     187.38000000000000	;     200.08571428571429	;     215.34999999999999	;     228.26250000000005	;     241.00000000000000	;     252.89562770000001	;     264.79125540000001		]; 
engine.fuel_map_gps = [
 -0.057912696810097156	  -0.22371937319975380	  -0.34457915699163849	  -0.35757820086091568	  -0.38014266986863110	  -0.40672889884951779	  -0.43362582068440442	  -0.45619431485165618	  -0.47381042232271564	  -0.48579761370357033	  -0.49205132870470741	  -0.49294829055445505	  -0.48898228428081308	  -0.48072491600788009	  -0.44673630598220349	  -0.38821650498364713	  -0.31993840443457461	  -0.22585928895262658	  -0.14080275169672785	;
 -0.037762944610459467	  -0.16508800552417058	  -0.21845901420337768	  -0.22563724425444340	  -0.23773297571984819	  -0.25114622070004661	  -0.26381135583259752	  -0.27381640265870016	  -0.28095652805236832	  -0.28421124162095607	  -0.28194136764843514	  -0.27238808749474147	  -0.25504696785550940	  -0.23219326875412452	  -0.18323658172469715	 -0.098618280181358250	 0.0015859499851049756	   0.14131439446054644	   0.28027235071342860	;
 -0.011876375841951283	 -0.034008635369004364	 -0.039712975833768573	 -0.039503838868974808	 -0.037713545814552565	 -0.032183548590974997	 -0.023167927461467029	 -0.011641544004347311	-0.00051064639562179879	 0.0084518568554424068	  0.018871815693675662	  0.040138103051140246	  0.075445413360155394	   0.11910472292933452	   0.19841539064449551	   0.31253936413535760	   0.44381394930371260	   0.66256627366124765	   0.87836633473326753	;
 0.0070927428252963807	  0.078850737172453403	   0.14348753251715254	   0.14655463942940383	   0.15191613695914619	   0.16502357647771823	   0.19161272876377952	   0.22696275185554735	   0.26528424351503838	   0.30349814214211351	   0.33578402625952658	   0.36762791875246209	   0.40436604094761769	   0.44708183681877967	   0.55809165626702462	   0.70620507277762312	   0.87519658924534605	    1.1622114898377749	    1.4438484625922965	;
  0.021395141173626338	   0.10827511220811295	   0.18231481772138258	   0.19826708353660916	   0.22734484749867173	   0.26534622377709532	   0.31291342090659285	   0.36375003038439635	   0.41644219400937038	   0.47005674734145719	   0.52016319170193137	   0.56997125121085024	   0.62222009698956693	   0.67764057981544268	   0.81782347281264067	    1.0009907768563198	    1.2062796827104660	    1.5382768555845541	    1.8643028344484383	;
  0.019964229168511219	   0.13175580090867184	   0.24632648339315491	   0.27145097080667679	   0.31662948054279777	   0.37278300438404222	   0.43448301460234456	   0.49519273741129488	   0.56151166691159993	   0.62935848164395669	   0.69950494393250162	   0.77366280706661628	   0.85271520492228703	   0.93865237000290247	    1.1302034288066150	    1.3661519318309829	    1.6216005335561317	    2.0049666324931197	    2.3839077855073252	;
  0.015873088767540788	   0.15467851754028034	   0.29936541644465098	   0.32971884904124343	   0.38402131954336993	   0.45224259057428007	   0.52946050718568305	   0.60560611652796348	   0.68134728645735443	   0.75854125330646138	   0.84093775424790629	   0.93016118105447831	    1.0270457902189911	    1.1319221185011727	    1.3602767797170474	    1.6268134767958453	    1.9083017964591107	    2.3362896053494833	    2.7556356809927718	;
  0.014093486460683449	   0.16887982610687710	   0.32905265477475198	   0.36226297119131634	   0.42155412441299384	   0.49610737791492215	   0.58066573630564222	   0.66390556335340267	   0.74582736436703345	   0.82973051007554466	   0.91942272032846561	    1.0182927990762984	    1.1252265218636666	    1.2399435504435325	    1.4874153008211757	    1.7701399240273550	    2.0647248695086269	    2.5176425701295155	    2.9600070184630165	;
  0.012463112858334562	   0.18924521694109184	   0.37007797755131216	   0.40684274720423330	   0.47246895084220930	   0.55525428288650458	   0.64870691344863207	   0.74080398380748513	   0.83226416114659896	   0.92631762790113115	    1.0275400709682607	    1.1382898376536574	    1.2578977938718039	    1.3857598690499247	    1.6591898131212390	    1.9628794559867624	    2.2750720347078537	    2.7606511035430716	    3.2347289099349794	;
  0.011954049300459697	   0.20772523320308764	   0.40612495899100010	   0.44598996605169894	   0.51714218253039768	   0.60661785230392951	   0.70732559943554552	   0.80780232858119905	   0.90900706833735090	    1.0132381843577409	    1.1233313075961882	    1.2427124480935225	    1.3722523568650531	    1.5113420845700118	    1.8096096437703859	    2.1304508930295882	    2.4584566609043126	    2.9712699925205381	    3.4737374035074748	;
  0.012319580893565702	   0.22907622360993296	   0.44670464945116473	   0.49004658552837660	   0.56731710373964117	   0.66433697928702518	   0.77302235273063091	   0.88461479410255950	   0.99785613172685350	    1.1137095279046068	    1.2329222906178112	    1.3609798715939656	    1.5017943033232271	    1.6538169073672657	    1.9799758049085618	    2.3198640083709958	    2.6663594817216270	    3.2092706238949358	    3.7449090789411441	;
  0.015749119331878302	   0.26758721474543984	   0.51740768703274698	   0.56681610706893204	   0.65481688242426928	   0.76598042566470337	   0.89259445170470464	    1.0261928056321301	    1.1608069143291246	    1.2966936714454464	    1.4325099731565827	    1.5784699571939556	    1.7403152765043262	    1.9140339714957171	    2.2794781614651676	    2.6535854139805526	    3.0330310361404034	    3.6318369135297890	    4.2310983528470869	;
  0.019861069576941313	   0.29972375895529557	   0.57541957940196131	   0.63046285797156443	   0.72856864029201951	   0.85305514496947821	   0.99639097390763931	    1.1447939827842244	    1.2930653378640526	    1.4438624581866599	    1.5959971037088865	    1.7575561809555389	    1.9339040501919316	    2.1229094337305092	    2.5213969946414485	    2.9223816971243810	    3.3271096171493397	    3.9804395086590514	    4.6383323691889533	;
  0.023512698156659313	   0.32684910097671016	   0.62575868001759305	   0.68530282765345107	   0.79123755713728783	   0.92512736590760092	    1.0786314238885701	    1.2378230997950650	    1.4005828247349539	    1.5640545960362331	    1.7273898543468218	    1.9015921520040029	    2.0898009364808505	    2.2911501097287568	    2.7163016322446958	    3.1388440690487371	    3.5658431257955860	    4.2667152240381281	    4.9758377456604155	;
  0.029434343445692773	   0.36589055429609429	   0.70080747020785805	   0.76630068806432050	   0.88293472327478961	    1.0317567228257352	    1.2014151108646638	    1.3771991613919896	    1.5570166693809646	    1.7338223725496993	    1.9096784514454177	    2.0985790786916341	    2.3034811096805430	    2.5202440765562693	    2.9795640236784746	    3.4385104534363982	    3.9010766251711075	    4.6723612434415074	    5.4583495487835174	;
  0.033618369345413762	   0.38653165801594819	   0.73739793934237685	   0.80744073054645327	   0.93206036633644340	    1.0896381201419563	    1.2693546877926993	    1.4522197192812292	    1.6408181424641650	    1.8257041434737176	    2.0076348250257747	    2.2041949777502601	    2.4167575709826927	    2.6411824962615453	    3.1183914042417329	    3.5985955425190950	    4.0826726471662163	    4.8923769452183654	    5.7215010777302915	;
  0.045760955120633703	   0.43092339846977973	   0.81542213160546528	   0.89291004729399359	    1.0311993981777416	    1.2095350508164233	    1.4112057854847329	    1.6062329581444528	    1.8084101482917425	    2.0083077262653202	    2.2075399303843000	    2.4200068834248971	    2.6503062771045158	    2.8931435597887103	    3.4110395459283125	    3.9347488707453406	    4.4670687293964333	    5.3615764889895416	    6.2855986442043230	;
  0.061589344525598277	   0.46981013351415424	   0.88307598694603895	   0.96574299826832921	    1.1122953592698754	    1.2996208388014485	    1.5139580175612735	    1.7253604374774041	    1.9369185130487214	    2.1470541841145523	    2.3598441407084612	    2.5873243083819273	    2.8309354493534542	    3.0875631728457220	    3.6398418216259043	    4.1956729133277681	    4.7677313728587700	    5.7349258290668805	    6.7362487480168065	;
  0.084089994558289846	   0.51314183306274186	   0.94822630609947223	    1.0358894031096924	    1.1923976279644659	    1.3905837116468232	    1.6176528455971215	    1.8442133883882930	    2.0705617554355493	    2.2922232347526768	    2.5128384000985289	    2.7514205763115283	    3.0092736993781481	    3.2805914968315273	    3.8660453510205097	    4.4608334370484499	    5.0765821486238556	    6.1226446603788869	    7.2040671905353424	;
   0.11941273594735624	   0.57116945142181252	    1.0194034910479741	    1.1110718476700567	    1.2753658917735908	    1.4871681070394978	    1.7358245806313430	    1.9833577766051156	    2.2277590689850308	    2.4609144777977328	    2.6928561385782461	    2.9410367045873769	    3.2137174323302542	    3.5028864179175572	    4.1253040025185141	    4.7690709369688475	    5.4405392775458230	    6.5824955624304113	    7.7558670640019507	;
   0.19902248877115689	   0.69560061986276356	    1.1724743001321976	    1.2612237502425279	    1.4189532370920490	    1.6267921759226205	    1.8906617364090175	    2.1794999011689358	    2.4701662519380285	    2.7281374803681318	    2.9737322980295602	    3.2397529344504119	    3.5344890446639425	    3.8491123708960728	    4.5358458768418162	    5.2694720214215591	    6.0418416504275418	    7.3359033223110535	    8.6415178394453314	;
   0.26045872934459741	   0.77950853075387405	    1.2949226977043111	    1.3916739505669466	    1.5653961856584280	    1.8005605189808411	    2.0795548002335598	    2.3541147847863413	    2.6409733726871663	    2.8952261689829344	    3.1446260558329415	    3.4154551225282970	    3.7203193963099772	    4.0513076479316750	    4.7906047507995275	    5.5938091312913363	    6.4298222046061877	    7.8028543005537951	    9.1736033738882483	;
   0.33382235283924522	   0.87637827721511541	    1.4271943183702056	    1.5458149602585767	    1.7632643900021323	    2.0667777065659640	    2.3751116647779091	    2.5498649247406084	    2.7949345670196011	    3.0517689618754553	    3.3070232905987451	    3.5856410743845508	    3.9049707647432963	    4.2599667945443782	    5.0668612148341952	    5.9435068914250966	    6.8414074222938313	    8.2846997517113170	    9.7129533472610792	;
   0.42321846173326144	    1.0063277958538268	    1.6246324380660369	    1.7648550684970470	    2.0212879236574892	    2.3607987047567631	    2.6248972891174835	    2.8088192232355507	    2.9941877758242685	    3.2227709788547245	    3.4758571581543496	    3.7689553005792162	    4.1061499845936584	    4.4831368383048655	    5.3714113573300013	    6.3232857219309917	    7.2756489791294738	    8.7780962709325792	    10.255942968624003	;
   0.57809053490179807	    1.2493764465604098	    1.9512309781214952	    2.0912778375990246	    2.3385208572886573	    2.6334538841054376	    2.9249670521377027	    3.1377552401299433	    3.3434994664998996	    3.5426895235077738	    3.7679028981332436	    4.0587269116507372	    4.4091018963927144	    4.8151862847922731	    5.8574024720568865	    6.8905458775586830	    7.8946550681145204	    9.4566659227065646	    10.988216332165150	;
   0.81797596948397311	    1.5732410744320973	    2.3106646408912859	    2.4510612804187812	    2.6971809158004101	    2.9939059126639536	    3.3091037830728269	    3.5958868954929932	    3.8748301160794885	    4.0981968425238859	    4.3171956086581984	    4.5711395029660293	    4.8972337925151681	    5.3083164553654756	    6.5737569706295842	    7.6474055961321890	    8.6818926135787375	    10.289180192523363	    11.867961578553539	;
    1.0296680974751695	    1.8252920327373812	    2.5947713527411875	    2.7441936113040168	    3.0077631361357735	    3.3321615779186802	    3.6905938521696142	    4.0385993080923193	    4.3725976138536540	    4.6557346603825103	    4.9168355105183643	    5.1703197929449596	    5.4966067443312125	    5.9368290194067663	    7.1439286568426690	    8.2918095459184080	    9.3593424030235788	    10.995030833430405	    12.607489009638986	;
    1.2294504341771570	    2.0572829808239423	    2.8707585001039240	    3.0318724138203876	    3.3173530491966896	    3.6717171891410696	    4.0662653162120774	    4.4505925030893287	    4.8237311813442965	    5.1836465764020376	    5.5387844100600843	    5.9104999560121740	    6.3220166312666617	    6.7940657329818466	    7.8817603849247257	    8.9607294543962368	    10.024316535338835	    11.685859033489217	    13.332233194448936	;
    1.4065303942367542	    2.2663867226774252	    3.1254893590209640	    3.2976884050119128	    3.6036496583492847	    3.9858376947748524	    4.4161893498937994	    4.8439284748965283	    5.2732821287468052	    5.7056213636899029	    6.1441005668205380	    6.5971609990502094	    7.0664796130280054	    7.5502752267276918	    8.5709291131541772	    9.6058989133590167	    10.647968043001384	    12.325920727244066	    14.005770449354795	;
    1.5790290070572186	    2.4727369730236939	    3.3778463677128943	    3.5612291476874010	    3.8879519132224569	    4.2993059229146757	    4.7698414928505954	    5.2484090296886929	    5.7404155171829139	    6.2438589947349046	    6.7543305997918335	    7.2700982401653063	    7.7830486794199008	    8.2877333677850835	    9.2729521398811965	    10.260967248307214	    11.274147418075799	    12.963554302193982	    14.677822567150741	]; 
engine.deac_fuel_map_gps = [
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.29215128940911494	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.29059553654112902	   0.33078977951619715	   0.36555340142445575	   0.40587877717514576	   0.44903116867339132	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.27384690972035275	   0.32079859421127860	   0.36587983413661623	   0.40999431532117259	   0.46643847147006590	   0.52976645389973631	   0.58495811296235012	   0.65603274932464495	   0.73389350193835090	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.29738934741695794	   0.35353193810398920	   0.41325800458237921	   0.47444541353348557	   0.53731613511888299	   0.60832336920420216	   0.68247239017901185	   0.75730992428889365	   0.84480816077914744	   0.93943790058178767	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.33785960031745221	   0.40080579693403895	   0.46744858452710963	   0.53585684393257971	   0.60814476148681507	   0.68924622266217028	   0.77110062153064218	   0.85213121239752965	   0.94536824972378475	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.39464147376561970	   0.46759343226239169	   0.54303039274415754	   0.62370351812336111	   0.70834940307301786	   0.79999623126302621	   0.89047062689386236	   0.98063353265836295	    1.0792990756498055	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.45144365409758880	   0.53202158454611448	   0.61293752162708137	   0.70128912957896483	   0.79635021064315259	   0.89600525149690458	   0.99570571015535336	    1.0929956501757869	    1.1965273598619461	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.51885056283283260	   0.60589425783377504	   0.69581031599270771	   0.79108321757145095	   0.89856512100612596	    1.0047485439428159	    1.1122170397638707	    1.2194219485875599	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.74614413384651412	   0.85958002945769585	   0.97113936618054997	    1.0984000639713341	    1.2132418045541593	    1.3293416712376445	    1.4517954289172701	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.98196182286007649	    1.1087865327193627	    1.2443753679689051	    1.3783199632373273	    1.5122536563467150	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	    1.2270762811093328	    1.3713183241188265	    1.5173331285094915	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('FTAG 28637');

% Idle Speed
engine.idle_target_speed_radps = class_REVS_dynamic_lookup;
engine.idle_target_speed_radps.axis_1.signal =  'eng_runtime_sec'; 
engine.idle_target_speed_radps.axis_1.breakpoints = [	     0.0000000000000000	    10.000000000000000		]; 
engine.idle_target_speed_radps.table = [	     60.737457969402662	    60.737457969402662		]; 

% Calibration Adjustment Factors
engine.variant =  'basic engine'; 
